#pragma once

#include "../sdkIncludes.h"
#include "jabber_meeting_csdk.h"

	class IDSMgrImpl : public IDSMgr
	{
	public:
		IDSMgrImpl();
		~IDSMgrImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		/**
		*@brief	set ds event for supporting callback
		*@param pEvent  ds event
		*/
		virtual void setDSEvent(IDSEvent* pEvent);

		/**
		*@brief	whether is in ds
		*@return  a bool value,true indicate is in ds false not
		*/
		virtual bool isInDS();

		/**
		*@brief	whether is in ds sharing
		*@return  a bool value,true indicate is in ds sharing false not
		*/
		virtual bool isSharingInDS();

		/**
		*@brief	judge whether can start ds currently
		*@param sessionName  ds session name
		*@return  a bool value true indicate can start ds false not
		*/
		virtual bool canStartDS(const PString sessionName);

		/**
		*@brief	judge whether can join ds currently
		*@param sessionName  ds session name
		*@return  a bool value true indicate can join ds false not
		*/
		virtual bool canJoinDS(const PString sessionName);

		/**
		*@brief	start ds
		*@param sessionName  ds session name
		*@param serverUrl  server url info
		*@param token  ds token
		*/
		virtual void startDS(const PString sessionName, const PString serverUrl, const PString token);

		/**
		*@brief	join ds
		*@param sessionName  ds session name
		*/
		virtual void joinDS(const PString sessionName);

		/**
		*@brief	decline ds invitation
		*@param sessionName  ds session name
		*/
		virtual void declineDSInvitation(const PString sessionName);

		/**
		*@brief	invite user into ds 
		*@param sessionName  ds session name
		*/
		virtual void inviteUser2DS(const PString sessionName);

		/**
		*@brief	end ds session
		*/
		virtual void endDS();

		/**
		*@brief	share ds again when already in ds session
		*/
		virtual void reSharing();

		/**
		*@brief	change ds presenter
		*/
		virtual void changePresenter();

		/**
		*@brief	receive ds invitation
		*@param sessionName  ds session name
		*@param cmdMsg  the message of ds invitation
		*/
		virtual void receiveDSInvitation(const PString sessionName, const PString cmdMsg);

		/**
		*@brief	receive ds decline
		*@param sessionName  ds session name
		*/
		virtual void receiveDSDecline(const PString sessionName);

		/**
		*@brief	receive ds cancelled
		*@param sessionName  ds session name
		*/
		virtual void receiveDSCancelled(const PString sessionName);

	public:
		pf_jmsdk_IDSMgr_setDSEvent mpfsetDSEvent;
		pf_jmsdk_IDSMgr_isInDS mpfisInDS;
		pf_jmsdk_IDSMgr_isSharingInDS mpfisSharingInDS;
		pf_jmsdk_IDSMgr_canStartDS mpfcanStartDS;
		pf_jmsdk_IDSMgr_canJoinDS mpfcanJoinDS;
		pf_jmsdk_IDSMgr_startDS mpfstartDS;
		pf_jmsdk_IDSMgr_joinDS mpfjoinDS;
		pf_jmsdk_IDSMgr_declineDSInvitation mpfdeclineDSInvitation;
		pf_jmsdk_IDSMgr_inviteUser2DS mpfinviteUser2DS;
		pf_jmsdk_IDSMgr_endDS mpfendDS;
		pf_jmsdk_IDSMgr_reSharing mpfreSharing;
		pf_jmsdk_IDSMgr_changePresenter mpfchangePresenter;
		pf_jmsdk_IDSMgr_receiveDSInvitation mpfreceiveDSInvitation;
		pf_jmsdk_IDSMgr_receiveDSDecline mpfreceiveDSDecline;
		pf_jmsdk_IDSMgr_receiveDSCancelled mpfreceiveDSCancelled;
	};

	class IInstantMeetingMgrImpl : public IInstantMeetingMgr
	{
	public:
		IInstantMeetingMgrImpl();
		~IInstantMeetingMgrImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
        /**
        *@brief register instant meeting event for supporting callback
        *@param pEvent  instant meeting event
        */
		virtual void registerIMEvent(IInstantMeetingEvent* pEvent);

        /**
        *@brief unregister instant meeting event for not supporting callback
        *@param pEvent  instant meeting event
        */
		virtual void unregisterIMEvent(IInstantMeetingEvent* pEvent);

        /**
        *@brief judge whether is in meeting
        *@return  a bool value, true indicate in meeting false not
        */
		virtual bool isInMeeting();

        /**
        *@brief judge whether is in sharing
        *@return  a bool value, true indicate in sharing false not
        */
		virtual bool isInSharing();

        /**
        *@brief judge can start meeting
        *@return  a bool value, true indicate can start false not
        */
		virtual bool canStartMeeting();

        /**
        *@brief judge whether can join meeting
        *@return  a bool value, true indicate can join false not
        */
		virtual bool canJoinMeeting();

        /**
        *@brief start meeting
        *@param meetingName  instant meeting name
        *@param inviteeList  the list of invitee
        */
		virtual void start(const PString meetingName, const PString inviteeList);

        /**
        *@brief invite into meeting
        *@param inviteeList  the list of invitee
        */
		virtual void invite(const PString inviteeList);

        /**
        *@brief join meeting
        *@param sessionName  instant meeting session name
        */
		virtual void join(const PString sessionName);

        /**
        *@brief decline meeting
        *@param sessionName  instant meeting session name
        */
		virtual void decline(const PString sessionName);

        /**
        *@brief receive meeting invitation
        *@param sessionName  instant meeting session name
        *@param cmdMsg  the message of meeting invitation
        */
		virtual void receiveMeetingInvitation(const PString sessionName, const PString cmdMsg);

        /**
        *@brief receive meeting decline
        *@param sessionName  instant meeting session name
        *@param cmdMsg  the message of meeting decline
        */
		virtual void receiveMeetingDeclinedMsg(const PString sessionName, const PString cmdMsg);

        /**
        *@brief receive meeting cancelled message
        *@param sessionName  instant meeting session name
        *@param cmdMsg  the message of meeting cancelled
        */
		virtual void receiveMeetingCancelledMsg(const PString sessionName, const PString cmdMsg);

        /**
		 *@brief judge whether is instant meeting 
		 *@param meetingKey  instant meeting key
		 */
		virtual bool isWbxInstantMeeting(const PString meetingKey);

        /**
		 *@brief start cmr meeting
		 *@param launch  whether launch cmr meeting
		 */
		virtual void startCmr(bool launch);

        /**
		 *@brief join cmr meeting
		 *@param strSiteURL  the site URL
		 *@param strMeetingKey  the meeting key
		 *@param strMTGTK  for security
		 */
		virtual void joinCmr(const PString strSiteURL, const PString strMeetingKey, const PString strMTGTK);

	public:
		pf_jmsdk_IInstantMeetingMgr_registerIMEvent mpfregisterIMEvent;
		pf_jmsdk_IInstantMeetingMgr_unregisterIMEvent mpfunregisterIMEvent;
		pf_jmsdk_IInstantMeetingMgr_isInMeeting mpfisInMeeting;
		pf_jmsdk_IInstantMeetingMgr_isInSharing mpfisInSharing;
		pf_jmsdk_IInstantMeetingMgr_canStartMeeting mpfcanStartMeeting;
		pf_jmsdk_IInstantMeetingMgr_canJoinMeeting mpfcanJoinMeeting;
		pf_jmsdk_IInstantMeetingMgr_start mpfstart;
		pf_jmsdk_IInstantMeetingMgr_invite mpfinvite;
		pf_jmsdk_IInstantMeetingMgr_join mpfjoin;
		pf_jmsdk_IInstantMeetingMgr_decline mpfdecline;
		pf_jmsdk_IInstantMeetingMgr_receiveMeetingInvitation mpfreceiveMeetingInvitation;
		pf_jmsdk_IInstantMeetingMgr_receiveMeetingDeclinedMsg mpfreceiveMeetingDeclinedMsg;
		pf_jmsdk_IInstantMeetingMgr_receiveMeetingCancelledMsg mpfreceiveMeetingCancelledMsg;
		pf_jmsdk_IInstantMeetingMgr_isWbxInstantMeeting mpfisWbxInstantMeeting;
		pf_jmsdk_IInstantMeetingMgr_startCmr mpfstartCmr;
		pf_jmsdk_IInstantMeetingMgr_joinCmr mpfjoinCmr;
	};

class IMeetingCalendarImpl : public IMeetingCalendar
{
public:
	IMeetingCalendarImpl();
	~IMeetingCalendarImpl();

	void FuncInit(JMHandle libHandle);
	void FuncUnInit();

public:
	/**
	 *
	 */
	virtual void setMCEvent(IMeetingCalendarEvent* pEvent);

	/**
	 * set reminder start & stop time (time unit is minute). the default start and stop time is: 
	 * 5 minutes before meeting start time and 10 minutes after meeting start time
	 * @param start	the reminder will be started from the start time. the possible value is:
	 *                  start > 0	before meeting start time
	 *                  start == 0  at meeting start time
	 *                  start < 0	after meeting start time
	 * @param stop	the reminder will be stopped until the stop time. the possible value is:
	 *					stop > 0	after meeting start time
	 *					stop == 0	at meeting start time
	 *					stop < 0	before meeting start time
	 */
	virtual void setReminderTime(long start = 5, long stop = 10);

	/**
	 *
	 */
	virtual void setMeetingReminderEnable(bool isEnable);

	/**
	 * initialize meeting and calendar
	 * @param type the type of integration calendar
	 */
	virtual void initialize(CalendarType type);

	/**
     * get integrated calendar type
     * @return the type of integrated calendar
     */
	virtual CalendarType getIntegrationCalendarType();

	/**
     * examine whether the meeting is enabled
     * @return
     */
	virtual bool isMeetingEnabled();

	/**
     * examine whether the calendar is enabled
     * @return
     */
	virtual bool isCalendarEnabled();

	/**
	 * examine whether the meeting in progress
	 * @return
	 */
	virtual bool isMeetingInProgress(const PString meetingID);

	/**
     * list meeting
     * @param mtDay 
     */
	virtual void listMeeting(MeetingTime mtDay);

	/**
     * refresh meeting
     */
	virtual void refreshMeeting();

	/**
     * get meeting day
     * @param mtDay 
     */
	virtual bool getMeetingDay(MeetingTime& mtDay);

    /**
     *
     */
	virtual bool getMeetingList(MeetingList& meetingList);

	/**
     * get meeting detail by meeting ID
     * @param meetingID
     * @return
     */
	virtual bool getMeetingDetail(const PString meetingID);

	/**
     * view meeting by meeting ID
     * @param meetingID
     * @return
     */
	virtual bool viewMeetingById(const PString meetingID);

	/**
     * launch meeting by meeting ID. start meeting for host and join meeting for attendee
     * @param meetingID
     * @return
     */
	virtual bool launchMeetingById(const PString meetingID);

	/**
     * invoke system time change, the user should call this method when system time is changed
     */
	virtual void invokeSystemTimeChange();

	/**
     * send email
     * @param tos email's recipients. multi recipients separated by ';'
     * @param subject
     * @param body
     * @param meetingID
     * @return
     */
	virtual bool sendEmail(const PString tos, const PString subject, const PString body, const PString meetingID);

	/**
	 * receive reminder
	 */
	virtual void receiveReminder(const PString sender, ReminderType remindType, const PString remindMsg);

	/**
	 * get remind command message
	 */
	virtual PString getRemindCommandMessage(const PString meetingID);

	/**
	 * get invite command message
	 */
	virtual PString getInviteCommandMessage(const PString meetingID);

    /**
     * get CMR Info
     */
	virtual void getCMRInfo(const PString cmrInfo);

public:
	pf_jmsdk_IMeetingCalendar_setMCEvent mpfsetMCEvent;
	pf_jmsdk_IMeetingCalendar_setReminderTime mpfsetReminderTime;
	pf_jmsdk_IMeetingCalendar_setMeetingReminderEnable mpfsetMeetingReminderEnable;
	pf_jmsdk_IMeetingCalendar_initialize mpfinitialize;
	pf_jmsdk_IMeetingCalendar_getIntegrationCalendarType mpfgetIntegrationCalendarType;
	pf_jmsdk_IMeetingCalendar_isMeetingEnabled mpfisMeetingEnabled;
	pf_jmsdk_IMeetingCalendar_isCalendarEnabled mpfisCalendarEnabled;
	pf_jmsdk_IMeetingCalendar_isMeetingInProgress mpfisMeetingInProgress;
	pf_jmsdk_IMeetingCalendar_listMeeting mpflistMeeting;
	pf_jmsdk_IMeetingCalendar_refreshMeeting mpfrefreshMeeting;
	pf_jmsdk_IMeetingCalendar_getMeetingDay mpfgetMeetingDay;
	pf_jmsdk_IMeetingCalendar_getMeetingList mpfgetMeetingList;
	pf_jmsdk_IMeetingCalendar_getMeetingDetail mpfgetMeetingDetail;
	pf_jmsdk_IMeetingCalendar_viewMeetingById mpfviewMeetingById;
	pf_jmsdk_IMeetingCalendar_launchMeetingById mpflaunchMeetingById;
	pf_jmsdk_IMeetingCalendar_invokeSystemTimeChange mpfinvokeSystemTimeChange;
	pf_jmsdk_IMeetingCalendar_sendEmail mpfsendEmail;
	pf_jmsdk_IMeetingCalendar_receiveReminder mpfreceiveReminder;
	pf_jmsdk_IMeetingCalendar_getRemindCommandMessage mpfgetRemindCommandMessage;
	pf_jmsdk_IMeetingCalendar_getInviteCommandMessage mpfgetInviteCommandMessage;
	pf_jmsdk_IMeetingCalendar_getCMRInfo mpfgetCMRInfo;
};

	class IWbxMeetingAccountQueryImpl : public IWbxMeetingAccountQuery
	{
	public:
		IWbxMeetingAccountQueryImpl();
		~IWbxMeetingAccountQueryImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		/**
		*@brief	register query event
		*@param pEvent   IWbxMeetingAccountEvent pointer
		*/
		virtual void registerQueryEvent(IWbxMeetingAccountEvent* pEvent);

		/**
		*@brief	unregister query event
		*@param pEvent   IWbxMeetingAccountEvent pointer
		*/
		virtual void unregisterQueryEvent(IWbxMeetingAccountEvent* pEvent);

		/**
		*@brief	check whether exist account
		*@return  a bool value
		*/
		virtual bool isExistAccount();

		/**
		*@brief	get wbx meeting account property
		*@return wbx meeting account property reference
		*/
		virtual WbxMeetingAccountProperty getAccountProperty();

		/**
		*@brief	get wbx meeting site property
		*@return wbx meeting site property reference
		*/
		virtual WbxMeetingSiteProperty getSiteProperty();

		/**
         *@brief get wbx meeting account name
         *@return  wbx meeting account name string
         */
		virtual PString getAccountName();

	public:
		pf_jmsdk_IWbxMeetingAccountQuery_registerQueryEvent mpfregisterQueryEvent;
		pf_jmsdk_IWbxMeetingAccountQuery_unregisterQueryEvent mpfunregisterQueryEvent;
		pf_jmsdk_IWbxMeetingAccountQuery_isExistAccount mpfisExistAccount;
		pf_jmsdk_IWbxMeetingAccountQuery_getAccountProperty mpfgetAccountProperty;
		pf_jmsdk_IWbxMeetingAccountQuery_getSiteProperty mpfgetSiteProperty;
		pf_jmsdk_IWbxMeetingAccountQuery_getAccountName mpfgetAccountName;
	};

	class IWbxMeetingAccountOperatorImpl : public IWbxMeetingAccountOperator
	{
	public:
		IWbxMeetingAccountOperatorImpl();
		~IWbxMeetingAccountOperatorImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		/**
		*@brief	clear account
		*/
		virtual void clearAccount();

		/**
		*@brief	reset account
		*@param accountProperty   wbx meeting account property reference
		*@param siteProperty   wbx meeting account site property
		*/
		virtual void resetAccount(const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty);

		/**
		*@brief	refresh session ticket
		*@param sessionTicket   session ticket
		*/
		virtual void refreshSessionTicket(const PString sessionTicket);

		/**
		*@brief	open one click setting in browser
		*/
		virtual void openOneClickSetting();

	public:
		pf_jmsdk_IWbxMeetingAccountOperator_clearAccount mpfclearAccount;
		pf_jmsdk_IWbxMeetingAccountOperator_resetAccount mpfresetAccount;
		pf_jmsdk_IWbxMeetingAccountOperator_refreshSessionTicket mpfrefreshSessionTicket;
		pf_jmsdk_IWbxMeetingAccountOperator_openOneClickSetting mpfopenOneClickSetting;
	};

	class IWbxMeetingAccountValidationImpl : public IWbxMeetingAccountValidation
	{
	public:
		IWbxMeetingAccountValidationImpl();
		~IWbxMeetingAccountValidationImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		/**
		*@brief	set validation callback event
		*@param pEvent   meeting account validation event
		*/
		virtual void setValidationEvent(IWbxMeetingAccountValidationEvent* pEvent);

		/**
		*@brief	get site sso info
		*@param url   site url 
		*/
		virtual CHECK_SITE_SSO_RESULT getSiteSSOInfo(const PString url);

		/**
		*@brief check site list sso info
		*@param siteList   data format : <aaa.webex.com><bbb.webex.com><ccc.webex.com>
		*/
		virtual void checkSiteListSSOInfo(const PString siteList);

		/**
		*@brief check site sso info
		*@param url   data format : aaa.webex.com
		*/
		virtual void checkSiteSSOInfo(const PString url);

		/**
		*@brief verify account info
		*@param siteURL   site url
		*@param userName   user name
		*@param isSSO   whether sso site
		*/
		virtual void verifyAccount(const PString siteURL, const PString userName, const PString userCred, bool isSSO);

	public:
		pf_jmsdk_IWbxMeetingAccountValidation_setValidationEvent mpfsetValidationEvent;
		pf_jmsdk_IWbxMeetingAccountValidation_getSiteSSOInfo mpfgetSiteSSOInfo;
		pf_jmsdk_IWbxMeetingAccountValidation_checkSiteListSSOInfo mpfcheckSiteListSSOInfo;
		pf_jmsdk_IWbxMeetingAccountValidation_checkSiteSSOInfo mpfcheckSiteSSOInfo;
		pf_jmsdk_IWbxMeetingAccountValidation_verifyAccount mpfverifyAccount;
	};

	class IJMSDKInstanceImpl : public IJMSDKInstance
	{
	public:
		IJMSDKInstanceImpl();
		~IJMSDKInstanceImpl();

		void FuncInit(JMHandle libHandle);
		void FuncUnInit();

	public:
		virtual void createJMSDK(bool isDesktopShareEnable, bool isMeetingAccountEnable, bool isInstantMeetingEnable, bool isMeetingListEnable);

		virtual void deleteJMSDK();

		virtual void startJMSDK();

		virtual void stopJMSDK();

		virtual void ChangeCapability(bool isDesktopShareEnable, bool isMeetingAccountEnable, bool isInstantMeetingEnable, bool isMeetingListEnable);

	public:
		pf_jmsdk_IJMSDKInstance_createJMSDK mpfcreateJMSDK;
		pf_jmsdk_IJMSDKInstance_deleteJMSDK mpfdeleteJMSDK;
		pf_jmsdk_IJMSDKInstance_startJMSDK mpfstartJMSDK;
		pf_jmsdk_IJMSDKInstance_stopJMSDK mpfstopJMSDK;
		pf_jmsdk_IJMSDKInstance_ChangeCapability mpfChangeCapability;
	};

	class IJabberMeetingSDKDelegateWrapper
	{
	public:
		void SetHandler(IJabberMeetingSDKDelegate* pIJabberMeetingSDKDelegate);
		void FuncInit(JMHandle libHandle);
	public:
		//IM Cmd
        /**
        *@brief send instant meeting invitation
        *@param buddyName  the name of invitee
        *@param cmdMsg  the message containing meeting invitation info
        *@param htmlMsg  the html message used for invitee join the meeting
        *@param plantMsg  the message of meeting invitation
        */
		static void sendInstantMeetingInvitation(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);

        /**
        *@brief cancel instant meetng invitation
        *@param buddyName  the name of invitee
        */
		static void sendInstantMeetingCancelInvitation(const PString buddyName);

        /**
        *@brief decline instant meetng invitation
        *@param buddyName  the name of invitee
        */
		static void sendInstantMeetingDecline(const PString buddyName);

        /**
        *@brief send desktop share invitation
        *@param buddyName  the name of invitee
        *@param cmdMsg  the message containing ds invitation info
        *@param htmlMsg  the html message used for invitee join the ds
        *@param plantMsg  the message of ds invitation
        */
		static void sendDesktopSharingInvitation(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);

        /**
        *@brief cancel desktop share invitation
        *@param buddyName  the name of invitee
        */
		static void sendDesktopSharingCancelInvitation(const PString buddyName);

        /**
        *@brief decline desktop share invitation
        *@param buddyName  the name of invitee
        */
		static void sendDesktopSharingDecline(const PString buddyName);

        /**
        *@brief get attendee email info
        *@param attendeeJID  the Jabber id of the attendee
        *@param attendeeEmail  out param to store attendee email
        */
		static void getAttendeeEmail(const PString attendeeJID, PString& attendeeEmail);

        /**
        *@brief get attendee display name
        *@param attendeeJID  the Jabber id of the attendee
        *@param attendeeEmail  out param to store attendee display name
        */
		static void getAttendeeDispalyName(const PString attendeeJID, PString& attendeeDN);

		//ds related
        /**
        *@brief hide chat window
        */
		static void hideChatWindow();

        /**
        *@brief show chat window
        */
		static void showChatWindow();

        /**
        *@brief the function is called when user try to leave desktop share
        *@param isHost whether the user is host or not
        */
		static void onUserTryLeave(bool isHost);

        /**
        *@brief get Jabber account name
        */
		static PString getJabberAccountName();

		static PString getJabberAccountNameFromEmail(const PString email);

		//Presence
        /**
        *@brief set the guest presence status as in meeting
        */
		static void addInMeetingPresence();

        /**
        *@brief remove the guest presence status of in meeting
        */
		static void removeInMeetingPresence();

        /**
        *@brief set the host presence status as in meeting but not sharing
        */
		static void addInWebExMeetingPresence();

        /**
        *@brief remove the host presence status of in meeting but not sharing
        */
		static void removeInWebExMeetingPresence();

        /**
        *@brief set the host presence status as in sharing
        */
		static void addInWebExSharingPresence();

        /**
        *@brief remove the host presence status of in sharing
        */
		static void removeInWebExSharingPresence();

        /**
        *@brief set the host presence status as in desktop share but not in sharing
        */
		static void addInDesktopSharingPresence();

        /**
        *@brief remove the host presence status of in desktop share but not in sharing
        */
		static void removeInDesktopSharingPresence();

        /**
        *@brief set the guest presence status as in desktop share and in sharing
        */
		static void addSharingInDesktopSharingPresence();

        /**
        *@brief remove the guest presence status of in desktop share and in sharing
        */
		static void removeShareingInDesktopSharingPresence();        

        //JCF related
		static bool isAccount(const PString & sessionName);

		static bool IsDSPolicyEnable(const PString & sessionName, int & nPolicyResult);

		static bool hasDSCapability(const PString & sessionName);

		static bool hasIMCapability(const PString & sessionName);

		static bool isBuddyOnline(const PString & sessionName);

		static bool isCupModel();

		static bool isWbxMeetingEnabled();

		// IM command, meeting reminder related
		static void sendMeetingReminder(const PString buddyName, const PString cmdMsg, const PString htmlMsg, const PString plantMsg);

	private:
		static IJabberMeetingSDKDelegate* m_pIJabberMeetingSDKDelegate;
	};

	class IJMLoggerWrapper
	{
	public:
		void SetHandler(IJMLogger* pIJMLogger);
		void FuncInit(JMHandle libHandle);
	public:
		static void log(int level, const char *sourceFile, int sourceLine, const char *function, const char *fmt, va_list args);

	private:
		static IJMLogger* m_pIJMLogger;
	};

class IMeetingCalendarEventWrapper
{
public:
	void SetHandler(IMeetingCalendarEvent* pIMeetingCalendarEvent);
	void FuncInit(JMHandle libHandle);
public:
	/**
	 * this method will be fired when calendar enabled/disabled
	 */
	static void onCalendarEnabled(bool bEnable);

	/**
	 * this method will be fired when meeting enabled/disabled
	 */
	static void onMeetingEnabled(bool bEnable);

	/**
	 * 
	 */
	static void onMeetingListed(MeetingCalendarErrorCode errCode);

	/**
	 * 
	 */
	static void onGetMeetingDetail(const MeetingData& meeting);

	/**
	 * 
	 */
	static void onMeetingOvernight();

	/**
	 * 
	 */
	static void onMeetingReminderHappened(const ReminderInfo& reminder);

    /**
	 *
	 */
	static void onMeetingReminderUpdated(const ReminderInfo& reminder);

	/**
	 * 
	 */
	static void onMeetingReminderEnded(const PString meetingID);

	/**
	 * 
	 */
	static void onMeetingStarted(const PString sessionName, const PString meetingID, bool host);

	/**
	 * 
	 */
	static void onMeetingEnded(const PString sessionName, const PString meetingID);

	/**
	 * 
	 */
	static void onMeetingError(const PString sessionName, const PString meetingID, int errCode);

	/**
	 * 
	 */
	static void onMeetingInvitationReceived(const PString sessionName, const PString meetingTopic);

	/**
	 * 
	 */
	static void onMeetingInvitationCanceled(const PString sessionName);

	/**
	 * 
	 */
	static void onMeetingDeclined(const PString sessionName, const PString buddyName);

	/**
	 *
	 */
	static void onPopupMeetingWaitDialog();

	/**
	 *
	 */
	static void onCloseMeetingWaitDialog();

    /**
     *
    */
	static void onCmrMeetingStarted(const JM_SDK::CmrMeetingData & meetingInfo);

    /**
     *
     */
	static void onCmrMeetingJoined();

    /**
     *
     */
	static void onCmrMeetingEnded();

    /**
     *
     */
	static void onCmrMeetingError(JM_SDK::INSTANT_MEETING_ERROR_CODE errorCode);

    /**
     *
     */
	static void onCmrInfo(const PString cmrInfo);

private:
	static IMeetingCalendarEvent* m_pIMeetingCalendarEvent;
};

	class IWbxMeetingAccountValidationEventWrapper
	{
	public:
		void SetHandler(IWbxMeetingAccountValidationEvent* pIWbxMeetingAccountValidationEvent);
		void FuncInit(JMHandle libHandle);
	public:
		/**
		*@brief	the method will be fired when check site list sso info
		*/
		static void onCheckSiteListSSOInfo();

		/**
		*@brief	the method will be fired when check site sso info
		*/
		static void onCheckSiteSSOInfo(WBX_MEETING_ACCOUNT_ERROR errorCode, const PString url, CHECK_SITE_SSO_RESULT result);

		/**
		*@brief	the method will be fired when verify account
		*@param result   meeting account status
		*@param accountProperty   meeting account property
		*@param siteProperty   meeting account property
		*/
		static void onVerifyAccount(WBX_MEETING_ACCOUNT_ERROR result, const WbxMeetingAccountProperty& accountProperty, const WbxMeetingSiteProperty& siteProperty);

	private:
		static IWbxMeetingAccountValidationEvent* m_pIWbxMeetingAccountValidationEvent;
	};

	class IDSEventWrapper
	{
	public:
		void SetHandler(IDSEvent* pIDSEvent);
		void FuncInit(JMHandle libHandle);
	public:
		/**
		*@brief pop up ds waiting dialog
		*/
		static void onPopupDSWaitingDialog();

		/**
		*@brief	close ds waiting dialog
		*/
		static void onCloseDSWaitingDialog();

		/**
		*@brief	the method will be fired when ds is started
		*@param sessionName   ds session name
		*/
		static void onDSStarted(const PString sessionName, bool isHost);

		/**
		*@brief	the method will be fired when ds is ended
		*@param sessionName   ds session name
		*/
		static void onDSEnded(const PString sessionName, bool isHost);

		/**
		*@brief	the method will be fired when ds status is error
		*@param errorCode   ds error status
		*@param sessionName   ds session name
		*/
		static void onDSError(const DS_ERROR_CODE errorCode, const PString sessionName);

		/**
		*@brief	pop up chat window
		*@param sessionName   ds session name
		*/
		static void onPopupChatWindow(const PString sessionName);

		/**
		*@brief	 minimize chat window
		*@param sessionName   ds session name
		*/
		static void onMinimizeChatWindow(const PString sessionName);

		/**
		*@brief	the method will be fired when receive ds invitation
		*@param sessionName   ds session name
		*/
		static void onDSInvitation(const PString sessionName);

		/**
		*@brief	the method will be fired when decline ds invitation
		*@param sessionName   ds session name
		*/
		static void onDSDeclined(const PString sessionName);

		/**
         *@brief the method will be fired when cancel ds invitation
         *@param sessionName   ds session name
         */
		static void onDSCancelled(const PString sessionName);

		/**
		*@brief	the method will be fired when ds sharing is stopped
		*@param sessionName   ds session name
		*/
		static void onSharingStopped(const PString sessionName);

		/**
		*@brief	the method will be fired when buddy joined ds session
		*/
		static void onBuddyJoined();

		/**
		*@brief	the method will be fired when user try to leave ds
		*@param isHost   whether the user is host or guest
		*/
		static void onUserTryLeave(bool isHost);

		/**
		*@brief	the method will be fired when user is leaved
		*/
		static void onUserLeft();

		/**
		*@brief	the method will be fired when presenter is changed
		*/
		static void onPresenterChanged();

	private:
		static IDSEvent* m_pIDSEvent;
	};

	class INetworkTransportWrapper
	{
	public:
		void SetHandler(INetworkTransport* pINetworkTransport);
		void FuncInit(JMHandle libHandle);
	public:
		static void HttpRequest(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

		static void HttpRequestAsync(const std::string& httpUrl, const std::vector<std::string>& httpHeader, const std::string& httpPostData, JMHttpMethod httpMethod, NetUtilSuccessProcT successProc, NetUtilErrorProcT errorProc);

		static bool Registered();

	private:
		static INetworkTransport* m_pINetworkTransport;
	};

